@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Edit Perusahaan</h1>
                    <p class="text-gray-600 mt-1">Edit data perusahaan {{ $company->name }}</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.companies.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                    <a href="{{ route('admin.companies.show', $company) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Detail
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.companies.update', $company) }}" class="space-y-6">
                        @csrf
                        @method('PUT')
                        
                        <!-- Company Information -->
                        <div class="bg-[#F6F6F6] p-4 rounded-none mb-6 border border-[#CBB4B0]">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Perusahaan</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                                        Nama Perusahaan *
                                    </label>
                                    <input type="text" id="name" name="name" value="{{ old('name', $company->name) }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('name')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                                        Email Perusahaan *
                                    </label>
                                    <input type="email" id="email" name="email" value="{{ old('email', $company->email) }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('email')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                                        Telepon Perusahaan *
                                    </label>
                                    <input type="text" id="phone" name="phone" value="{{ old('phone', $company->phone) }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('phone')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="contact_person" class="block text-sm font-medium text-gray-700 mb-2">
                                        Nama Kontak *
                                    </label>
                                    <input type="text" id="contact_person" name="contact_person" value="{{ old('contact_person', $company->contact_person) }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('contact_person')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="contact_phone" class="block text-sm font-medium text-gray-700 mb-2">
                                        Telepon Kontak *
                                    </label>
                                    <input type="text" id="contact_phone" name="contact_phone" value="{{ old('contact_phone', $company->contact_phone) }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('contact_phone')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="contact_email" class="block text-sm font-medium text-gray-700 mb-2">
                                        Email Kontak *
                                    </label>
                                    <input type="email" id="contact_email" name="contact_email" value="{{ old('contact_email', $company->contact_email) }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('contact_email')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div class="mt-6">
                                <label for="address" class="block text-sm font-medium text-gray-700 mb-2">
                                    Alamat Perusahaan *
                                </label>
                                <textarea id="address" name="address" rows="3" required
                                          class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">{{ old('address', $company->address) }}</textarea>
                                @error('address')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mt-6">
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
                                    Deskripsi Perusahaan
                                </label>
                                <textarea id="description" name="description" rows="3"
                                          class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">{{ old('description', $company->description) }}</textarea>
                                @error('description')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mt-6">
                                <div class="flex items-center">
                                    <input type="checkbox" id="is_active" name="is_active" value="1" 
                                           {{ old('is_active', $company->is_active) ? 'checked' : '' }}
                                           class="h-4 w-4 text-[#CBB4B0] focus:ring-[#CBB4B0] border-gray-300 rounded">
                                    <label for="is_active" class="ml-2 block text-sm text-gray-900">
                                        Perusahaan Aktif
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Access Codes -->
                        <div class="bg-[#192D50] border border-[#CBB4B0] rounded-none p-4">
                            <h4 class="font-medium text-white mb-2">Kode Akses:</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="text-sm text-white">Kode Perusahaan:</p>
                                    <p class="font-mono text-lg font-bold text-white">{{ $company->company_code }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-white">Kode Akses:</p>
                                    <p class="font-mono text-lg font-bold text-white">{{ $company->access_code }}</p>
                                </div>
                            </div>
                            <p class="text-sm text-white mt-2">
                                Kode akses dapat direset dari halaman detail perusahaan.
                            </p>
                        </div>

                        <div class="flex items-center justify-end space-x-4">
                            <a href="{{ route('admin.companies.index') }}" 
                               class="px-4 py-2 border border-[#8B8B8B] rounded-none text-sm font-medium text-[#8B8B8B] hover:bg-[#8B8B8B] hover:text-white transition duration-150">
                                Batal
                            </a>
                            <button type="submit" 
                                    class="px-6 py-2 bg-[#192D50] text-white rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                                Update Perusahaan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
